REBOL [
    subject: "cration ou modification d'une description"
    author: "Olivier Auverlot"
]

; lecture des paramtres transmis
methode: system/options/cgi/request-method

either methode = "GET" [
    ; permet de rcuprer action et clescript pour les effacer
    data: system/options/cgi/query-string
] [
    data: copy ""
    len: to-integer system/options/cgi/content-length
    until [
        buffer: copy ""
        read-io system/ports/input buffer (to-integer system/options/cgi/content-length)
        append data buffer
        data: head data
        ((length? data) = len)
    ]
]
var: make object! decode-cgi data
action: to-integer var/action

print "Content-type: text/html^/"
print {
    <HTML>
    </HEAD>
        <TITLE>Modification de la base</TITLE>
    </HEAD>
    <BODY>
}

db: open odbc://scripts
p: first db

switch action [
    1 [
        ; cration d'une fiche
        insert p [
            {INSERT INTO scripts (titre,categorie,description,auteur) 
            VALUES(?,?,?,?) 
            } var/titre var/categorie var/description var/auteur
        ]
    ]
    2 [
        ; mise  jour d'une fiche
        insert p [
            {UPDATE scripts 
            SET titre=?,categorie=?,description=?,auteur=? 
            WHERE cle=?} 
            var/titre var/categorie var/description
            var/auteur var/clescript
        ]
    ]
    3 [
        ; effacement de la fiche
        insert p [ "DELETE FROM scripts WHERE cle=?" var/clescript ] 
    ]
]
print { 
<CENTER>
<H1>Opration termine</H1> 
<A href="listescripts.cgi">Retour</A>
</CENTER>
}
close p
close db
print "</BODY></HTML>"